// decal.vsh

uniform mat4 vc0;	// worldViewProj
uniform vec3 vc8;	// sun direction
uniform vec3 vc9;	// sun color
uniform vec3 vc10;	// ambient color

void main()
{
	// transform position
	gl_Position = gl_Vertex * vc0;

	// pass in coords
    gl_TexCoord[0].st = gl_MultiTexCoord0.st;

	// calculate lit color
	// normal dot light
	float intensity = max( dot(gl_Normal, vc8), 0.0);
	
	// Modulate with sun color
	vec3 r0 = vc9 * intensity;
	
	// Add ambient color
	r0 += vc10;
	
	gl_FrontColor = vec4( r0, gl_Color.a );
}

/*
vs.1.1

def c20, 0, 1, 0.5, 2
def c21, 1, 1, 1, 1

dcl_position v0;
dcl_normal v1;
dcl_texcoord0 v2;
dcl_color0 v3;

// transform position
m4x4 oPos, v0, c0

// pass in coords
mov oT0, v2

// calculate lit color
// normal dot light
dp3 r0.x, v1, c8
max r0.x, r0.x, c20.x

// Modulate with sun color
mul r0.xyz, c9.xyz, r0.x

// Add ambient color
add r0.xyz, r0.xyz, c10
mov r0.w, v3.a

mov oD0, r0
*/
